/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile',
    'hbs!applets/wound-care-applet/core/extensions/list-generator/core/views/patients/patient',
    'applets/wound-care-applet/core/extensions/list-generator/core/models/patients/Patient' ],
    function (Portal, Backbone, Marionette, $, _, jqm, template) {
        'use strict';

        return Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _, template) {
            ListGenerator.PatientView = Backbone.Marionette.ItemView.extend({
                model: ListGenerator.Patient,
                tagName: 'li',
                template : template,

                initialize: function(){
                },
                templateHelpers: function() {
                    var ret;
                    if (this.model.get('skinAssessmentCompleted')) {
                        var today = new Date();

                        ret = {ago:this.daydiff(this.parseDate(this.model.get('lastSkinAssessmentCompleted')), today),'lastSkinAssessmentCompleted':this.grabDate(this.model.get('lastSkinAssessmentCompleted')).join('/')};
                        this.model.set();
                    }
                    return ret;
                },
                parseDate:function(str) {
                    var mdy = this.grabDate(str);
                    return new Date(mdy[2], mdy[0]-1, mdy[1]);
                },
                grabDate:function(str) {
                    var mdy = str.split('/');
                    mdy[2] = mdy[2].split(' ')[0];
                    return mdy;
                },
                daydiff:function(first, second) {
                    return Math.floor((second-first)/(1000*60*60*24));
                }
            });
        }, template);
    });